define([
    'underscore',
    'backbone',
    'marionette',
    'modules/notification-preferences/notification-preferences-module',
    'modules/form/section-view',
    'modules/notification-info/notification-info-popup-view',
    'text!modules/form/section-with-heading.html',
    'text!modules/notification-preferences/_email-notification-info-button.html',
    'json!modules/notification-preferences/notification-form.json',
],
function(
    _,
    Backbone,
    Marionette,
    module,
    SectionView,
    NotificationInfoPopup,
    template,
    _emailNotificationInfoButton,
    metadata
) {
    'use strict';

    return SectionView.extend({
        template: template,
        events: {
            'click input[name=optIn]': 'updateEmailAddressShown',
            'keyup input[name=optIn]': 'updateEmailAddressShown',
            'click #notification-info-btn': 'goToNotificationInfo',
        },
        initialize: function(options) {
            var sectionName = 'notification-form-inputs';
            this.legend = this.getLegendFromMetadata(sectionName, metadata, false) || '';
            this.collection = this.getQuestionsFromMetadata(sectionName, metadata, options);

            // initialize listener to 'change:value' after static values are set
            this.initializeQuestionEventListeners();
            this.validator = options.validator;
            this.errorSection = options.errorSection;
            this.collection.get('optIn').set('selected', this.model.get('optIn'));
            this.isForExpressCare = options.isForExpressCare;
            this.isVideoStopCode = options.isVideoStopCode;
        },

        updateQuestionValuesAndRender: function(contactPreferences) {
            if (!this.isDestroyed()) {
                this.collection.each(function(question) {
                    question.set('value', contactPreferences.get(question.get('id')));
                }, this);
                this.render();

                this.initChildren();
                this.showHideChildrenQuestionsAndValidation('.email-notification', !this.model.get('optIn'));
            }
        },

        onRender: function() {
            var $optInRadio;

            this.initChildren();
            this.showHideChildrenQuestionsAndValidation('.email-notification', !this.model.get('optIn'));
            this.$el.find("legend[for='optIn']")
                .append(_.template(_emailNotificationInfoButton)());

            this.listenTo(module.notificationPreferences, 'sync', this.updateQuestionValuesAndRender);
            if (this.isForExpressCare || this.isVideoStopCode) {
                $optInRadio = this.$el.find('input[type="radio"][name="optIn"]');
                $optInRadio
                    .prop('disabled', true)
                    .parent('label')
                    .addClass('ui-disabled');
            }
        },

        updateEmailAddressShown: function(e) {
            var isOptOut;
            if (e) {
                isOptOut = e.currentTarget.value !== 'true';
                this.showHideChildrenQuestionsAndValidation('.email-notification', isOptOut);
            }
        },

        showHideChildrenQuestionsAndValidation: function(selector, isHidden) {
            var children;

            if (!this.isDestroyed()) {
                children = this.$el.find(selector);
                children.toggleClass('hidden', isHidden);
                if (isHidden) {
                    this.hideValidationErrorsFor(children);
                    if (this.errorSection) {
                        this.$el.parent().siblings(this.errorSection)
                            .addClass('hidden');
                    }
                }
            }
        },

        goToNotificationInfo: function () {
            var uiButton = this.$el.find('#notification-info-btn');
            var notificationInfoPopup = new NotificationInfoPopup({elAfterClose: '#' + uiButton.attr('id')});
            notificationInfoPopup.openPopup();
        },
    });
});
